function [ Data_Readin_TrialSubj, gender_matrix, size_matrix, subj_readin] = readin_PMAnalyzer( readin_inputcell, varargin )
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

nr_files_readin             = readin_inputcell{1};
trials_readin               = readin_inputcell{2};
subj_readin                 = readin_inputcell{3};
prefix                      = readin_inputcell{4};
folder_with_data            = readin_inputcell{5};
file_type_ending            = readin_inputcell{6};
delimiterIn                 = readin_inputcell{7};
headerlinesIn               = readin_inputcell{8};
delete_specific_col_yn      = readin_inputcell{9};
delete_specific_marker_yn   = readin_inputcell{10};
columns_should_have         = readin_inputcell{11};
rows_should_have            = readin_inputcell{12};
specific_col_to_delete      = readin_inputcell{13};
specific_marker_to_delete   = readin_inputcell{14};
save_data_matrix            = readin_inputcell{15};
name_data_matrix            = readin_inputcell{16};
Gap_filling_option          = readin_inputcell{17};
% cycle_analysis              = readin_inputcell{18};
order                       = readin_inputcell{19};
cut_off_norm                = readin_inputcell{20};
filter_readin               = readin_inputcell{21}; % Filter option 6 if filtered
path_save_data              = readin_inputcell{22};
cut_off_now                 = readin_inputcell{23};
delete_specific_rows_yn     = readin_inputcell{24};
specific_rows_to_delete     = readin_inputcell{25};
TransformOption             = readin_inputcell{26};
SampleFreq                  = readin_inputcell{27};

max_subj_readin      = max(subj_readin);
max_trials_readin    = max(trials_readin);
TransformCoords      = TransformOption{1,1}; % Yes or no: from {1,2}, to {1,3}

if size(varargin, 2) == 0
    special_data_treat_yn = 0;
else
    special_data_treat_yn        = varargin{1};
    preProcessing_option         = varargin{2};
end


%% Initialization
Data_Readin_TrialSubj = cell(max_trials_readin,max_subj_readin);
Data_Readin_TrialSubj_additional(max_trials_readin,max_subj_readin) = struct;
size_matrix = zeros(max_trials_readin,max_subj_readin);
gender_matrix = repmat('m',[max_trials_readin, max_subj_readin]); % Default m
cleared_subjects=[];
clear_index=0;


consider_gender = 0;
if consider_gender == 1
    %     gender_matrix = ['ffmfmmfmmmmffmffmfmfmfmfmm';'ffmfmmfmmmmffmffmfmfmfmfmm']; % Arunee
    %     fprintf('Gender classification: Arunee 1 leg stance\n')
    %     msgbox('Gender classification: Arunee 1 leg stance')
    
    %     gender_matrix = ['m','f','m','m','f','f','m','f','f','f',  'f','f','f','f','f','f','f','m','f','f',  'f','m','f','m','m' ...
    %                   'm','m','f','f','m','f','f','f','f','f',  'm','f','f','f','m','f','f','f','m','m',  'f','f','m','f','f']; % Tommyuso first Projekt
    %     fprintf('Gender classification: Tommyuso tandem stance\n')
    %     msgbox('Gender classification:Tommyuso tandem stance')
    
    gender_matrix = 'mmmmfmfmmmmmfffffmfmf'; % COP quiet
    fprintf('Gender classification: Tommy quiet stance COP\n')
    msgbox('Gender classification: Tommy quiet stance COP')
    
else
    for TrialNow = 1:max_trials_readin
        for SubjNow = 1:max_subj_readin
            if sum(TrialNow == setdiff(1:max_trials_readin, trials_readin)) || sum(SubjNow == setdiff(1:max_subj_readin, subj_readin))
                gender_matrix(TrialNow, SubjNow) = 0; % clear
            end
        end
    end
    fprintf('Gender classification: ALL MALE DEFAULT - No classification\n\n')
    %     msgbox('Gender classification: ALL MALE DEFAULT - No classification')
end



if TransformCoords
    msgbox('Coordinate Transformation after readin activated!');
end


for TrialNow = trials_readin
    % Optimization idea: use parfor instead of for: Check if numbers
    % correspond to format 1:1:Nr subs --> get rid of counters before!
    for SubjNow = subj_readin
        % ************* READ IN DATA AND SPECIFY GENDER ***************
        
        
        % Specify file to read in
        file_ReadIn = [prefix, 's', num2str(SubjNow),'t',num2str(TrialNow), file_type_ending];
        fprintf('\nTrial %d - subject %d is being read in (File: "%s")!', TrialNow,SubjNow, file_ReadIn)
        % Actual Readin of previously specifies file
        if headerlinesIn == 0
            [Data__] = importdata(fullfile(folder_with_data,file_ReadIn),delimiterIn);
            Data = Data__;
        else
            [Data__] = importdata(fullfile(folder_with_data,file_ReadIn),delimiterIn,headerlinesIn);
            Data = Data__.data;
        end
        
        
        %% Tove sampling issue
%         
%         if SubjNow == 1:3
%             Data = resample(Data,3,5);
%             fprintf('\nTove sampling activated: 250Hz to 50Hz\n')
%         else
%             fprintf('\nTove sampling activated: 150Hz to 50Hz\n')
%         end
%         
%         
%         
%         Data_Readin_TrialSubj_additional(TrialNow, SubjNow).AfterReadingIn = [];
        
        
        
        %% ************* Cut specific columns, markers or rows if selected in GUI ***************
        if delete_specific_col_yn == 1
            Data(:,specific_col_to_delete) = [];
        end
        
        if delete_specific_marker_yn == 1
            cut_markers = specific_marker_to_delete;
            cut_markers = sort(cut_markers,2,'descend');
            cut_out = zeros(1,length(cut_markers)*3);
            for i=1:length(cut_markers)
                cut_out(3*i-2+0)= 3*cut_markers(i)-2+0;
                cut_out(3*i-2+1)= 3*cut_markers(i)-2+1;
                cut_out(3*i-2+2)= 3*cut_markers(i)-2+2;
            end
            Data(:,cut_out) = [];
        end
        
        if delete_specific_rows_yn == 1
            Data(intersect(specific_rows_to_delete, 1:size(Data, 1)), :) = [];
        end
        
        % Check code for Nan (not a number) or incorrect number of columns (not dividable by 3)
        [~, ~, ~] = checkRowCol(Data, [1,1,1]) ;
        
        
        
        
        
        if special_data_treat_yn == 1
            nr_preProcStep = 1;
            fprintf('       Subject %d trial %d is being pre-processed (step 1: after reading in and deleting markers, cols and rows)', SubjNow, TrialNow)
            [Data, Data_additional_PP1, ~] = optionsPreProcessing(Data, Data_Readin_TrialSubj_additional, preProcessing_option, nr_preProcStep, TrialNow, SubjNow);
            Data_Readin_TrialSubj_additional(TrialNow, SubjNow).FromPreProc_1 = Data_additional_PP1;
        end
        
        
        
        

        
        
        
        %% ************* Gapfilling as selected in GUI ***************
        
        Data_Readin_TrialSubj(TrialNow, SubjNow) = {Data};
        Data_Readin_TrialSubj_additional(TrialNow, SubjNow).AfterCutting = [];
        size_matrix(TrialNow, SubjNow) = size(Data,1);
        
        if Gap_filling_option == 1
            %% No Gapfilling
            fprintf('\n      Gap filling Option 1 (No Gapfilling) chosen!\n\n')
            
            
        elseif Gap_filling_option == 2
            %% Gap filling all subj, trials together!
            if TrialNow == trials_readin(end) && SubjNow == subj_readin(end)
                Data_for_Gapfilling = [];
                for TrialNowGap = trials_readin
                    for SubjNowGap = subj_readin
                        Data_for_Gapfilling = [Data_for_Gapfilling; Data_Readin_TrialSubj{TrialNowGap, SubjNowGap}];
                    end
                end
                % Check code for Nan (not a number) or incorrect number of columns (not dividable by 3)      
                [colProblem, rowProblem, xyzProblem] = checkRowCol(Data_for_Gapfilling, [1,1,1]) ; 
                errStrings = {'', '', '';'There is a NaN column in data.', 'There is a NaN row in data.', 'Number Columns not dividable by three (x-y-z format necessary).'};
                if sum([colProblem, rowProblem, xyzProblem]) == 1
                    error('\n\nPManalyzer found error in input data: Check read in data. Gap-filling can not be performed because: %s %s %s', errStrings{colProblem+1, 1}, errStrings{rowProblem+1,2}, errStrings{xyzProblem+1,3})
                end
                
                gaps_in_data_all = sum(sum(isnan(Data_for_Gapfilling)));
                fprintf('\n\n      Gap filling Option 2 (all subjects and all trials together) is being performed (Total Gaps in data: %d)\n', gaps_in_data_all)
                if gaps_in_data_all ~= 0
                    Data_gapfilled = PredictMissingMarkers_ForSubmission(Data_for_Gapfilling);
                    %                         Data_gapfilled = PredictMissingMarkers(Data_for_Gapfilling);
                    % % % % %                     A = exist([path_save_data, '\Later Gap filled data'], 'dir');
                    % % % % %                     if A == 7
                    % % % % %                     else
                    % % % % %                         mkdir([path_save_data,'\Later Gap filled data'])
                    % % % % %                     end
                    % % % % %                     save([path_save_data,'\Later Gap filled data\PreGap_filled_Data_Subject ',num2str(SubjNow), ' - Trial ',num2str(TrialNow)],'Data_for_Gapfilling')
                else
                    Data_gapfilled = Data_for_Gapfilling;
                end
                size_matrix1 = size_matrix(size_matrix ~= 0)'; % Flip to run through subjects first!
                tsNow = 0;
                for TrialNowGap = trials_readin
                    for SubjNowGap = subj_readin
                        tsNow = tsNow + 1;
                        Data_Readin_TrialSubj{TrialNowGap, SubjNowGap} = Data_gapfilled(sum(size_matrix1(1:tsNow))+1-size_matrix1(1):sum(size_matrix1(1:tsNow)),:);
                    end
                end
            end
            
            
        elseif Gap_filling_option == 3
            
% % %                 % Check code for Nan (not a number) or incorrect number of columns (not dividable by 3)      
% % %                 [colProblem, rowProblem, xyzProblem] = checkRowCol(Data_for_Gapfilling, [1,1,1]) ; 
% % %                 errStrings = {'', '', '';'There is a NaN column in data.', 'There is a NaN row in data.', 'Number Columns not dividable by three (x-y-z format necessary).'};
% % %                 if sum([colProblem, rowProblem, xyzProblem]) == 1
% % %                     error('\n\nPManalyzer found error in input data: Check read in data. Gap-filling can not be performed because: %s %s %s', errStrings{colProblem+1, 1}, errStrings{rowProblem+1,2}, errStrings{xyzProblem+1,3})
% % %                 end

            
            % % % %             %% Gap filling for all trials of one subject together
            % % % %             if TrialNow == trials_readin(end) && SubjNow == subj_readin(end)
            % % % %                 % Permute to have all trials of each subject together
            % % % %                 for ctrSubj = 1:max_subj_readin
            % % % %                     Data_for_Gapfilling = [];
            % % % %                     for ctrTrial = 1:max_trials_readin
            % % % %                         if size(Data_all_perm{counter_subj + ctrTrial},2) == columns_should_have
            % % % %                             Data_for_Gapfilling = [Data_for_Gapfilling; Data_Readin_TrialSubj{ctrTrial, ctrSubj}];
            % % % %                         else
            % % % %                             error('Input matrix does not have the required number of columns! (%d instead of %d)',size(Data_all_perm{counter_subj + i},2), columns_should_have)
            % % % %                         end
            % % % %                     end
            % % % %                     gaps_in_data_subj = sum(sum(isnan(Data_for_Gapfilling)));
            % % % %                     if gaps_in_data_subj ~= 0
            % % % %                         fprintf('\n\n      Gap filling Option 3 (all trials of each subject together) is being performed (%d Gaps in Data)\n', gaps_in_data_subj)
            % % % %                                                 Data_gapfilled = PredictMissingMarkers_ForSubmission(Data_for_Gapfilling);
            % % % % %                         Data_gapfilled = PredictMissingMarkers(Data_for_Gapfilling);
            % % % %                         gaps_in_data_after_gapfill = sum(sum(isnan(Data_gapfilled)));
            % % % %                         fprintf('      Gap filling Option 3 finished (%d Gaps in Data)\n', gaps_in_data_after_gapfill)
            % % % %                         A = exist([path_save_data,'\Later Gap filled data'], 'dir');
            % % % %                         if A == 7
            % % % %                         else
            % % % %                             mkdir([path_save_data,'\Later Gap filled data'])
            % % % %                         end
            % % % %                         save([path_save_data,'\Later Gap filled data\PreGap_filled_Data_Subject ',num2str(SubjNow), ' - Trial ',num2str(TrialNow)],'Data_for_Gapfilling')
            % % % %
            % % % %                     else
            % % % %                         Data_gapfilled = Data_for_Gapfilling;
            % % % %                     end
            % % % %                     for ctrTrial= 1:max_trials_readin
            % % % %                         Data_Readin_TrialSubj{ctrTrial,ctrSubj} = Data_gapfilled(sum(size_matrix(1:ctrTrial, ctrSubj))+1:sum(size_matrix(1:ctrTrial+1, ctrSubj)),:);
            % % % %                     end
            % % % %                 end
            % % % %
            % % % %                 % Permute back to have all subjects of each trial together
            % % % %                 permutation_to_trial_subj = zeros(1,nr_files_readin);
            % % % %                 for i = 1:max_trials_readin
            % % % %                     for Subj = 1:max_subj_readin
            % % % %                         permutation_to_trial_subj(Subj+(i-1)*max_subj_readin) = i+(Subj-1)*max_trials_readin;
            % % % %                     end
            % % % %                 end
            % % % %                 Data_Readin_TrialSubj = Data_Readin_TrialSubj(permutation_to_trial_subj);
            % % % %             end
            % % % %
            msgbox('Gapfilling option 3 not working')
            
            % Gap filling for every read in data set separately!
        elseif Gap_filling_option == 4
            Data_for_Gapfilling = Data;
            nr_gaps_before = sum(sum(isnan(Data)));
            if nr_gaps_before == 0
                
            else
                % Check code for Nan (not a number) or incorrect number of columns (not dividable by 3)      
                [colProblem, rowProblem, xyzProblem] = checkRowCol(Data_for_Gapfilling, [1,1,1]) ; 
                errStrings = {'', '', '';'There is a NaN column in data.', 'There is a NaN row in data.', 'Number Columns not dividable by three (x-y-z format necessary).'};
                if sum([colProblem, rowProblem, xyzProblem]) == 1
                    error('\n\nPManalyzer found error in input data: Check read in data. Gap-filling can not be performed because: %s %s %s', errStrings{colProblem+1, 1}, errStrings{rowProblem+1,2}, errStrings{xyzProblem+1,3})
                end

                fprintf('      Gap filling is being performed (%d Gaps in Data)\n', nr_gaps_before)
                Data = PredictMissingMarkers_ForSubmission(Data);
                %                     Data = PredictMissingMarkers(Data);
                % % % % %                 A = exist([path_save_data,'\Later Gap filled data'], 'dir');
                % % % % %                 if A == 7
                % % % % %                 else
                % % % % %                     mkdir([path_save_data,'\Later Gap filled data'])
                % % % % %                 end
                % % % % %                 save([[path_save_data,'\Later Gap filled data\PreGap_filled_Data_Subject ',num2str(l), ' - Trial ',num2str(k)],'Data')
                
                nr_gaps_after = sum(sum(isnan(Data)));
                fprintf('             ... finished(%d Gaps in Data)\n', nr_gaps_after)
                
            end
            Data_Readin_TrialSubj{TrialNow, SubjNow} = Data;
        end % Gapfilling
        % Save files after Gapfilling
        %         Data_now = Data_all{TrialSubjReal-1};
        %         dlmwrite(['C:\Users\c6211068\Desktop\Data to analyse\SquatHold\', prefix, '_gapfilled_s', num2str(SubjNow), 't', num2str(TrialNow),'.txt'], Data_now)
        
        
        Data_Readin_TrialSubj_additional(TrialNow, SubjNow).AfterGapfilling = [];
        
        
        %% If data should be flipped (right and left are exchanged)
        if special_data_treat_yn == 1
            nr_preProcStep = 2;
            [DataAfterPP2,Data_additional_PP2, ~] = optionsPreProcessing(Data_Readin_TrialSubj{TrialNow, SubjNow}, Data_Readin_TrialSubj_additional, preProcessing_option, nr_preProcStep, TrialNow, SubjNow);
            Data_Readin_TrialSubj{TrialNow, SubjNow} = DataAfterPP2;
            Data_Readin_TrialSubj_additional(TrialNow, SubjNow).FromPreProc_2 = Data_additional_PP2;
        end
    end % for SubjNow = subj
end % for TrialNow = trials_readin






%% Transformation into other coordinates

if TransformCoords
    for TrialNowTC = trials_readin
        for SubjNowTC = subj_readin % -1 because TrialSubjReal has already been augmented 1 before this option
            [Data_Readin_TrialSubj{TrialNowTC, SubjNowTC}, ~] = optionsTransformData(Data_Readin_TrialSubj{TrialNowTC, SubjNowTC}, TransformOption{1,2}, TransformOption{1,3});
            Data_Readin_TrialSubj_additional(TrialNow, SubjNow).AfterTrannsformData = [];
        end
    end
    fprintf('\n    Coordinate Transformation after readin activated!\n');
else
end






%% *************   Readin filter  ***************
colsXYZProblemDat = [];
colsNAnProblemDat = [];
rowsNAnProblemDat = [];
for TrialNowFilt = trials_readin
    for SubjNowFilt = subj_readin % -1 because TrialSubjReal has already been augmented 1 before this option
        if filter_readin == 1
        elseif filter_readin == 2
            [B,A] = butter(order,cut_off_norm); % 5th order lowpass with cutoff at cut_off_f 5Hz
            Data_Readin_TrialSubj{TrialNowFilt,SubjNowFilt} = filtfilt(B,A,Data_Readin_TrialSubj{TrialNowFilt,SubjNowFilt});
        end
        
        if special_data_treat_yn == 1
            nr_preProcStep = 3;
            [DataAfterPP3,Data_additional_PP3, ~] = optionsPreProcessing(Data_Readin_TrialSubj{TrialNowFilt, SubjNowFilt}, Data_Readin_TrialSubj_additional, preProcessing_option, nr_preProcStep, TrialNow, SubjNow);
            Data_Readin_TrialSubj{TrialNowFilt, SubjNowFilt} = DataAfterPP3;
            Data_Readin_TrialSubj_additional(TrialNowFilt, SubjNowFilt).FromPreProc_3 = Data_additional_PP3;
        end
        
        colsPostProcessing = size( Data_Readin_TrialSubj{TrialNowFilt, SubjNowFilt},2);
        if mod(colsPostProcessing, 3) ~= 0 % Safety if Columns not dividable by three! (Expectation: x,y,z of each coordinate after readin!!!)
            colsXYZProblemDat = [colsXYZProblemDat, [TrialNowFilt; SubjNowFilt]];
        end
        nr_columns_only_nan = sum(sum(isnan(Data_Readin_TrialSubj{TrialNowFilt, SubjNowFilt}),1) == size(Data_Readin_TrialSubj{TrialNowFilt, SubjNowFilt},1));
        if nr_columns_only_nan ~= 0
            colsNAnProblemDat = [colsNAnProblemDat, [TrialNowFilt; SubjNowFilt]];
        end
        nr_rows_only_nan = sum(sum(isnan(Data_Readin_TrialSubj{TrialNowFilt, SubjNowFilt}),2) == size(Data_Readin_TrialSubj{TrialNowFilt, SubjNowFilt},2));
        if nr_rows_only_nan ~= 0
            rowsNAnProblemDat = [rowsNAnProblemDat, [TrialNowFilt; SubjNowFilt]];
        end
    end
end

% Output errors with data! Still contain Nan or not x-y-z format
if ~isempty(colsXYZProblemDat) % Safety is Columns not dividable by three! (Expectation: x,y,z of each coordinate)
    fprintf('\n\nATTENTION: The columns of at least one data set is not dividable by three after pre-processing! The code expects x-y-z of each marker (no time-frames or other columns) after pre-processing.\nUse pre-processing steps to delete unwanted columns\n\n')
    warndlg('ATTENTION: The columns of at least one data set is not dividable by three! The code expects x-y-z of each marker (no time-frames or other columns) after pre-processing. Use pre-processing steps to delete unwanted columns.')
    fprintf('\nData of ')
    for trSub = 1:size(colsXYZProblemDat, 2)
        fprintf('T%d-S%d, ', colsXYZProblemDat(1, trSub), colsXYZProblemDat(2, trSub))
    end
    fprintf(' are not in x-y-z column format!\n\n')
    error('ERROR found in PManalyzer computation: Columns after pre-processign not dividable by three!')
else
end





%% *************   Safety if all subjects are cut out  ***************
subj_readin(cleared_subjects)=[]; %cuts out left or right subjects if needed
if special_data_treat_yn == 1 && sum(sum(~cellfun(@isempty,Data_Readin_TrialSubj)))==0
    msgbox('There were no subjects that met the flipping/cut-out criteria! No subjects readin', 'Error', 'Error')
    error('There were no subjects that met the flipping/cut-out criteria! No subjects readin!')
elseif special_data_treat_yn == 1
    fprintf('\n\n%d subjects that met the flipping/leave-out criteria were read in!',size(Data_Readin_TrialSubj,2))
    if clear_index > 0
        fprintf('\n      There were %d subjects that did not match the readin criteria! --> They were left out and not read in!\n', clear_index)
    end
else
    fprintf('\n\nNo "special data treatment" was chosen!\n\n')
end




%% **************    Save or not (as selected in GUI)   ***************
if save_data_matrix
    path_and_name = [path_save_data, '\',num2str(cut_off_now),'CO___',name_data_matrix];
    fprintf('\nRead in data is saved as: \n     %s\n', path_and_name)
    save(path_and_name,'Data_Readin_TrialSubj','gender_matrix', 'size_matrix');
    save([path_and_name, '_additional'],'Data_Readin_TrialSubj_additional');
end




end


